package cn.com.duiba.live.activity.center.api.dto.market;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 营销活动表
 *
 * @Author xujing
 * @Date 2021/10/19 10:06 上午
 */

@Data
public class MarketActivityDto implements Serializable {

    private static final long serialVersionUID = 523484442544961986L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动规则
     */
    private String activityRules;

    /**
     * 活动开始时间
     */
    private Date startTime;

    /**
     * 活动结束时间
     */
    private Date endTime;

    /**
     * 活动类型 1支付有礼
     */
    private Integer activityType;

    /**
     * 支付限制类型 1全付通支付
     */
    private Integer payLimit;

    /**
     * 活动状态 0未开启 1已开启
     */
    private Integer activityStatus;

    /**
     * 活动参与人数限制
     */
    private Integer joinNumLimit;

    /**
     * 每个客户限制次数
     */
    private Integer timesLimit;

    /**
     * 活动奖励 1盲盒抽奖
     */
    private Integer activityReward;

    /**
     * 奖励领取地址
     */
    private String rewardAddress;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否删除 0未删除 1已删除
     */
    private Integer isDel;
}