package cn.com.duiba.live.activity.center.api.dto.seckill;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by sunyan on 2019/5/29.
 */
@Data
public class SecKillActForFrontDto implements Serializable {

    private static final long serialVersionUID = -1563722023228357408L;
    /**
     * 活动名称
     */
    private String title;

    /**
     * 开始时间戳
     */
    private Long startTimestamp;

    /**
     * 结束时间戳
     */
    private Long endTimestamp;

    /**
     * 最早开始时间戳
     */
    private Long firstStartTimestamp;

    /**
     * 最后结束时间戳
     */
    private Long lastEndTimestamp;

    /**
     * 运行状态：参照SecKillActForUnitRunStatusEnum
     */
    private Integer runStatus;

    /**
     * 对应的商品id
     */
    private Long appItemId;

    /**
     * 对应的商品小图链接
     */
    private String itemSmallImage;

    /**
     * 商品详情图
     */
    private String multiImage;

    /**
     * 卖点描述
     */
    private String sellingPoint;

    /**
     * 划线价（单位：元）
     */
    private String facePrice;

    /**
     * 秒杀需要钱（单位：元）
     */
    private String secPrice;

    /**
     * 秒杀需要积分
     */
    private String secCredits;

    /**
     * 当期spu级别已秒杀数量
     */
    private Integer currentSecCount;

    /**
     * 当期spu级别秒杀总限制数量
     */
    private Integer currentSecLimit;

    /**
     * 剩余总秒杀库存
     */
    private Integer totalStock;

    /**
     * 详情页地址
     */
    private String link;

    /**
     * 是否已预约
     */
    private Integer appointment = 0;
}
