package cn.com.duiba.live.activity.center.api.enums.scene;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 活动扩展字段枚举
 *
 * @author ouyang
 * @date 2021-11-03
 **/
@Getter
public enum LiveActivitySceneExtEnum {

    /**
     * LiveActivitySceneEnum 直播场景枚举下各活动在场景下的扩展实现
     */

    LIVE_BROADCASTING_ROOM_POP_IMG(1, "直播间场景 活动展示的伸缩图"),
    ;

    /**
     * 键  长度限制64
     */
    Integer key;
    /**
     * 描述  长度限制1024
     */
    String desc;


    LiveActivitySceneExtEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    //全部元素
    private static final Map<Integer, LiveActivitySceneExtEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveActivitySceneExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    public static LiveActivitySceneExtEnum getByType(String key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    public static LiveActivitySceneExtEnum of(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     * @param key
     * @return
     */
    public static boolean contains(String key) {
        if (StringUtils.isBlank(key)) {
            return false;
        }
        for (LiveActivitySceneExtEnum enumVal : LiveActivitySceneExtEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

}
