package cn.com.duiba.live.activity.center.api.remoteservice.fission.blindbox;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.blindbox.BlindBoxGoodsDto;

import java.util.List;

/***
 * @author chenh
 * @since 2021-11-25 15:23:17
 */
@AdvancedFeignClient
public interface RemoteBlindBoxGoodsService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BlindBoxGoodsDto queryById(Long id);

    /**
     * 新增数据
     *
     * @param dto 实例对象
     * @return 生成的主键id
     */
    Long insert(BlindBoxGoodsDto dto);

    /**
     * 修改数据
     *
     * @param dto 实例对象
     * @return 实例对象
     */
    int update(BlindBoxGoodsDto dto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);

    /**
     * 根据盲盒id获取配置的商品
     * @param blindBoxId  盲盒id
     * @return 商品列表
     */
    List<BlindBoxGoodsDto> getGoodsInfo(Long blindBoxId);

    /**
     * 新增或者减少盲盒库存
     * @param blindGoodsId 盲盒商品id
     * @param stockNum  库存
     * @return 结果
     */
    boolean incrOrDecrGoodsStock(Long blindGoodsId, Integer stockNum);

    /**
     * 初始化商品库存
     * @param blindGoodsId 盲盒商品id
     * @return 结果
     */
    boolean initGoodsStock (Long blindGoodsId);
}
