package cn.com.duiba.live.activity.center.api.remoteservice.multiprize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.multiprize.LiveMultiPrizeOptionDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/5/31 19:39
 */
@AdvancedFeignClient
public interface RemoteLiveMultiPrizeOptionService {

    /**
     * 保存抽奖配置
     * @param goods
     * @return
     */
    int save(List<LiveMultiPrizeOptionDto> goods);

    /**
     * 查询直播间配置
     * @param confId 半价配置ID
     * @return
     */
    List<LiveMultiPrizeOptionDto> getByConfId(Long confId);

    /**
     * 查询直播间配置抽奖奖品
     * @param confIds 抽奖ID
     * @return 奖品列表
     */
    List<LiveMultiPrizeOptionDto> getByConfIds(List<Long> confIds);

}
