package cn.com.duiba.live.activity.center.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.guide.LiveGuideProcessRecordDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2020/12/5 10:30 上午
 */
@AdvancedFeignClient
public interface RemoteLiveGuideProcessRecordService {

    /**
     * 查询用户的所有参与记录
     * @param liveId
     * @param userId
     * @return
     */
    List<LiveGuideProcessRecordDto> listByLiveUserId(Long liveId, Long userId);

    /**
     * 统计已经发送的红包数
     * @param liveId
     * @return
     */
    Integer countSendRed(Long liveId);

    /**
     * 插入一条数据
     * @param liveGuideProcessRecordDto
     * @return
     */
    Long insert(LiveGuideProcessRecordDto liveGuideProcessRecordDto);
}
