package cn.com.duiba.live.activity.center.api.remoteservice.marketcoupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.marketcoupon.MarketCouponRecordDto;
import cn.com.duiba.live.activity.center.api.param.marketcoupon.MarketCouponRecordSearchParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMarketCouponRecordService {

    long save(MarketCouponRecordDto marketCouponRecordDto);

    long saveList(List<MarketCouponRecordDto> marketCouponRecordDtos);

    List<MarketCouponRecordDto> findListByParam(MarketCouponRecordSearchParam param);

    /**
     * 统计公司下已发放的优惠券总量
     */
    long countTotalGrantCouponByConfId(Long confId);

    long countTotalGrantPersonByConfId(Long confId);

    long countByParam(MarketCouponRecordSearchParam param);
}
