package cn.com.duiba.live.activity.center.api.enums.user.point;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author ouyang
 * @date 2022/04/24 13:55
 * @description 积分消费订单状态
 */
@Getter
@AllArgsConstructor
public enum UserPointConsumeOrderStatusEnum {

    PRE_CONSUME(1, "订单预消费"),
    SUCCESS(2, "订单消费成功"),
    FAIL(3, "订单消费失败"),
    ;

    /**
     * 状态
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 枚举Map K：type V：枚举
     */
    private static final Map<Integer, UserPointConsumeOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(UserPointConsumeOrderStatusEnum.values()).collect(Collectors.toMap(UserPointConsumeOrderStatusEnum::getType, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据类型查询枚举
     */
    public static UserPointConsumeOrderStatusEnum getByStatus(Integer status) {
        if (NumberUtil.isNullOrLteZero(status)) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
