package cn.com.duiba.live.activity.center.api.remoteservice.credit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.credit.CreditCardActivityDto;
import cn.com.duiba.live.activity.center.api.param.credit.CreditCardActivitySearchParam;

import java.util.List;

/**
 * @author chenhang
 * @date 2021/8/16 8:23 下午
 */
@AdvancedFeignClient
public interface RemoteCreditCardActivityService {

    /**
     * 查询数量
     * @param param 查询条件
     * @return 数目
     */
    Long countByParam(CreditCardActivitySearchParam param);

    /**
     * 分页查询
     * @param param 查询条件
     * @return 列表
     */
    List<CreditCardActivityDto> pageByParam(CreditCardActivitySearchParam param);


    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    CreditCardActivityDto queryById(Long id);


    /**
     * 新增数据
     *
     * @param creditCardActivityDto 实例对象
     * @return 实例对象
     */
    long insert(CreditCardActivityDto creditCardActivityDto);

    /**
     * 修改数据
     *
     * @param creditCardActivityDto 实例对象
     * @return 实例对象
     */
    int update(CreditCardActivityDto creditCardActivityDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);



}
