package cn.com.duiba.live.activity.center.api.remoteservice.fission.invite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.invite.InviteGoodsDto;

import java.util.List;

/**
 * @author zht
 * @Description mgm邀请有礼活动商品
 * @createTime 2022年05月18日
 */
@AdvancedFeignClient
public interface RemoteInviteGoodsService {

    /**
     * stock,sales,sortNum字段不要传null，可赋默认值0
     * @param list
     * @return
     */
    int batchSave(List<InviteGoodsDto> list);

    /**
     * 仅更新stock,gear,num字段
     * 因需更新库存，使用了数据库行锁
     * @param goodsDto
     * @return
     */
    int updateStockAndGear(InviteGoodsDto goodsDto);

    /**
     * 根据活动id查询商品列表
     * @param activityId
     * @param ignore 是否过滤未上线商品
     * @return
     */
    List<InviteGoodsDto> selectByActivityId(Long activityId, Boolean ignore);

    /**
     * 删除商品
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据id查询商品
     * @param ids
     * @param ignore 是否过滤未上线商品
     * @return
     */
    List<InviteGoodsDto> selectByIds(List<Long> ids, Boolean ignore);

    /**
     * 根据id查询商品
     * @param id
     * @return
     */
    InviteGoodsDto selectById(Long id);

    /**
     *
     * @param id
     * @param offset
     * @return -1 参数异常，0 库存不足
     */
    int decreaseStock(Long id, Integer offset);
}
