package cn.com.duiba.live.activity.center.api.remoteservice.flipword;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.flipword.LiveFlipWordResultRecordDto;

import java.util.List;

/**
 * 翻牌集字-翻牌结果记录
 *
 * @author chenh
 * @date  2021-11-10 13:41:16
 */
@AdvancedFeignClient
public interface RemoteLiveFlipWordResultRecordService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    LiveFlipWordResultRecordDto queryById(Long id);


    /**
     * 新增数据
     *
     * @param liveFlipWordResultRecordDto 实例对象
     * @return 影响行数
     */
    int insert(LiveFlipWordResultRecordDto liveFlipWordResultRecordDto);

    /**
     * 修改数据
     *
     * @param liveFlipWordResultRecordDto 实例对象
     * @return 影响行数
     */
    int update(LiveFlipWordResultRecordDto liveFlipWordResultRecordDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 异步批量新增翻牌结果记录
     *
     * @param list 翻牌结果记录
     */
    void asyncBatchInsertResultRecord(List<LiveFlipWordResultRecordDto> list);
}
