package cn.com.duiba.live.activity.center.api.remoteservice.red.doublered;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.red.doublered.DoubleRedConfDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/4/8 11:32
 */
@AdvancedFeignClient
public interface RemoteDoubleRedConfService {

    /**
     * 保存翻倍红包配置
     * @param dto 配置
     * @return
     */
    int save(DoubleRedConfDto dto);

    /**
     * 更新翻倍红包配置
     * @param dto 更新后配置
     * @return
     */
    int updateById(DoubleRedConfDto dto);

    /**
     * 根据ID获取配置
     * @param id
     * @return
     */
    DoubleRedConfDto getById(Long id);

    /**
     * 批量获取
     * @param ids
     * @return
     */
    List<DoubleRedConfDto> listByIds(List<Long> ids);

    /**
     * 获取当前直播间配置的翻倍红包
     * @param liveId 直播间ID
     * @return
     */
    DoubleRedConfDto getByLive(Long liveId);

    int deleteById(Long id);

}
