package cn.com.duiba.kjy.api.enums.home;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @create 2020-04-08 13:40
 * @descript 是否置顶公众号
 */
public enum StickyOnTopEnum {
    /**
     * 0：取消置顶，1:置顶
     */
    REMOVE_FROM_TOP(0, "取消置顶"),
    ON_TOP(1, "置顶"),
    ;

    private Integer code;
    private String desc;

    StickyOnTopEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, StickyOnTopEnum> ENUM_MAP = new HashMap<>();

    static{
        for(StickyOnTopEnum onTopEnum : values()){
            ENUM_MAP.put(onTopEnum.getCode(), onTopEnum);
        }
    }

    public static StickyOnTopEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
