package cn.com.duiba.kjy.api.dto.kouyi;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangbinbin
 * @create 2020-09-09 09:46
 * @descript 口以预约支付订单dto
 */
@Data
public class KouyiPayRecordDto implements Serializable {


    private static final long serialVersionUID = 1672916078157653222L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 付费金额(分)
     */
    private Long amount;

    /**
     * 付款状态，1=待付款、2=付款中、3=付款成功、4=付款失败
     */
    private Integer payStatus;

    /**
     * 交易号
     */
    private String tradeNo;

    /**
     * 微信交易号
     */
    private String wxTradeNo;

    /**
     * 支付结果时间
     */
    private Date payResultTime;

    /**
     * 支付关联业务id，课程id
     */
    private Long bizId;

}
