package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/11/19 11:05 AM
 */
public enum CustomPrizeTypeEnum {

    SELLER_CUSTOM(1, "销售员指定中奖人"),
    SELLER_RATE(2, "销售员概率中奖"),
    ;

    private Integer type;

    private String desc;

    CustomPrizeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, CustomPrizeTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(CustomPrizeTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static CustomPrizeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static PrizeTypeEnum getPrizeTypeEnum(Integer type) {
        CustomPrizeTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return null;
        }
        switch (typeEnum) {
            case SELLER_CUSTOM:
                return PrizeTypeEnum.SELLER_CUSTOM;
            case SELLER_RATE:
                return PrizeTypeEnum.SELLER_RATE;
            default:
                return null;
        }
    }
}
