package cn.com.duiba.kjy.api.enums.shareEntrance;


import java.util.stream.Stream;

/**
 * 分享入口配置相对应对象的
 */
public enum ShareEntranceObjectEnum {
    /**
     * 未付费代理人
     */
    UN_PAY_SELLER(1,"未付费代理人"),
    /**
     * 访客
     */
    VISIT(2,"访客"),
    ;

    ShareEntranceObjectEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static ShareEntranceObjectEnum  getByCode(Integer code){
        return Stream.of(ShareEntranceObjectEnum.values()).filter(shareEntranceObjectEnum -> shareEntranceObjectEnum.getCode().equals(code)).findFirst().orElse(null);
    }
}
