package cn.com.duiba.kjy.api.enums.fission;

import java.util.HashMap;
import java.util.Map;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月28日 11:54
 **/
public enum FissionAwardTypeEnum {

    PDF("PDF", "PDF文档", "//yun.duiba.com.cn/kjy-fission-web/icons/icon-pdf.png", "//yun.duiba.com.cn/kjy-fission-web/icons/icon-book.png"),

    AUDIO("AUDIO", "音频", "//yun.dui88.com/kjy-fission-web/icons/icon-music.png", "//yun.dui88.com/kjy-fission-web/icons/icon-play.png"),

    VIDEO("VIDEO", "视频", "//yun.dui88.com/kjy-fission-web/icons/icon-video.png", "//yun.dui88.com/kjy-fission-web/icons/icon-play.png"),

    ;
    private String value;
    private String text;

    /**
     * 图标
     */
    private String icon;

    /**
     * 操作图标
     */
    private String operatorIcon;

    FissionAwardTypeEnum(String value, String text, String icon, String operatorIcon) {
        this.value = value;
        this.text = text;
        this.icon = icon;
        this.operatorIcon = operatorIcon;
    }

    private static final Map<String, FissionAwardTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(FissionAwardTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getValue(), typeEnum);
        }
    }

    public static FissionAwardTypeEnum getByValue(String value) {
        if (value == null) {
            return null;
        }
        return ENUM_MAP.get(value);
    }

    public String getValue() {
        return value;
    }

    public String getText() {
        return text;
    }

    public String getIcon() {
        return icon;
    }

    public String getOperatorIcon() {
        return operatorIcon;
    }
}
