package cn.com.duiba.kjy.api.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 活动指定中奖，昵称模糊匹配工具方法
 * @author zzy
 * @date  2019/11/23 17:35
 */
public class NicknameMatchUtil {

    private static final int MIN_LENGTH = 2;

    private NicknameMatchUtil() {
    }

    /**
     * 昵称是否匹配
     *
     * @param target   目标昵称（昵称全名）
     * @param nickname 昵称（用户输入，昵称部分字符）,至少2个字符以上
     * @return true-匹配，false-不匹配
     */
    public static boolean isMatch(String target, String nickname) {
        if (StringUtils.isAnyEmpty(target, nickname)) {
            //有任意一个为空时，必须都为空才算匹配
            return Objects.equals(target, nickname);
        }
        //去除前后空格
        target = target.trim();
        nickname = nickname.trim();

        if (Objects.equals(target, nickname)) {
            return true;
        }
        if (StringUtils.isAnyEmpty(target, nickname) || nickname.length() < MIN_LENGTH) {
            return false;
        }
        return target.toLowerCase().contains(nickname.toLowerCase());
    }
}
