package cn.com.duiba.kjy.api.remoteservice.preInstall;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallBatchDetailDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.preInstall.PreInstallPageQuery;

/**
 * 直播预设会员详情
 * @author chengsiyi
 * @date 2021/3/15 14:45
 */
@AdvancedFeignClient
public interface RemotePreInstallBatchDetailService {

    /**
     * 查询或者新增批次明细
     * @param dto
     * @return
     */
    PreInstallBatchDetailDto getOrAddByBatchIdAndLiveUser(PreInstallBatchDetailDto dto);

    /**
     * 根据用户和批次查询明细
     * @param batchId 批次ID
     * @param liveUserId 用户ID
     * @return 明细
     */
    PreInstallBatchDetailDto selectOneByBatchAndLiveUser(Long batchId, Long liveUserId);

    /**
     * 分页查询激活明细
     * @param preInstallPageQuery
     * @return
     */
    Page<PreInstallBatchDetailDto> queryBatchDetailPage(PreInstallPageQuery preInstallPageQuery);
}
