package cn.com.duiba.kjy.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangbinbin
 * @create 2020-09-02 14:27
 * @descript 保存更新用户公众号信息dto
 */
@Data
public class UserOaAddUpdateDto implements Serializable {

    private static final long serialVersionUID = 6976868196546923122L;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 主键
     */
    private Long extId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 公众号是否已关注：0=未关注、1=已关注
     */
    private Integer subscribe;

    /**
     * 类型：oa=公众号、mp=小程序
     */
    private String extType;

    /**
     * 微信接口返回 accessToken，用户解密敏感数据
     */
    private String accessToken;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     *是否正在使用
     */
    private Boolean using;

}
