package cn.com.duiba.kjy.api.params.user;

import lombok.Data;

import java.io.Serializable;

/**
 * @author chenhang
 * @date 2021/8/25 4:42 下午
 */
@Data
public class UserExtSearchParam implements Serializable {

    private static final long serialVersionUID = 2659165315532299178L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;
    /**
     * 直播用户ID，对应tb_live_users.id
     */
    private Long liveUserId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 公众号是否已关注：0=未关注、1=已关注
     */
    private Integer subscribe;

    /**
     * 类型：oa=公众号、mp=小程序
     */
    private String extType;

    /**
     * 微信接口返回 session_key，用户解密敏感数据
     */
    private String accessToken;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     *是否正在使用
     */
    private Boolean using;

}
