/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class FormatUtils {
    private FormatUtils() {
    }

    public static String format(String template, Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\{\\{.*?\\}\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            m.appendReplacement(sb, value == null ? "" : Matcher.quoteReplacement(value.toString()));
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]", "\n");
        message = message.replaceAll("\\[s\\]", " ");
        return message;
    }

    public static String formatSkipIfNull(String template, Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)template)) {
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\{\\{.*?\\}\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            if (!Objects.nonNull(value)) continue;
            m.appendReplacement(sb, value == null ? "" : Matcher.quoteReplacement(value.toString()));
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]", "\n");
        message = message.replaceAll("\\[s\\]", " ");
        return message;
    }

    public static String subLargeString(String source, int maxLength, int shotLength) {
        if (StringUtils.isBlank((String)source) || source.length() <= maxLength) {
            return source;
        }
        return source.substring(0, shotLength) + "...";
    }

    public static String quoteReplacement(String title) {
        if (StringUtils.isBlank((String)title)) {
            return title;
        }
        title = Matcher.quoteReplacement(title);
        title = StringUtils.replaceOnce((String)title, (String)"\"", (String)"\u201c");
        title = StringUtils.replaceOnce((String)title, (String)"\"", (String)"\u201d");
        title = StringUtils.replaceOnce((String)title, (String)"\"", (String)"\u201c");
        title = StringUtils.replaceOnce((String)title, (String)"\"", (String)"\u201d");
        return title;
    }

    public static Map<String, String> formatString2Map(String source) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String oaIDPic : source.split(",")) {
            if (!oaIDPic.contains(":")) continue;
            String[] split = oaIDPic.split(":");
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static void main(String[] args) {
        String collect = Arrays.asList("a{{test}}", "b", "c").stream().collect(Collectors.joining("[n]"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("test", "tet[n]te[s]st");
        System.out.println(FormatUtils.format(collect, map));
    }
}

