package cn.com.duiba.kjy.api.dto.successCases;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户成功案例表
 * @author kjj mybatis generator 
 * 2020-05-14
 */
@Data
public class SuccessCasesDto implements Serializable {
    private static final long serialVersionUID = 1589440066558730L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;


    /**
     *
     *文章id，对应tb_content主键id
     * not null default = null
     */
    private Long contentId;

    /**
     * 一级标签id
     */
    private Long firstTagId;

    /**
     *
     *排序
     * not null default = 1
     */
    private Long listOrder;

    /**
     *
     *是否锁定位置，0:未锁定，1:锁定
     * not null default = 0
     */
    private Integer isLocked;


    /**
     *
     *案例名称
     * max length = 100
     */
    private String caseName;

    /**
     *
     *用户头像
     * max length = 255
     */
    private String userAvatar;

    /**
     *
     *用户姓名
     * max length = 50
     */
    private String userName;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}