package cn.com.duiba.kjy.api.enums.grasscontent;

import cn.com.duiba.kjy.api.util.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * 种草素材推送场景枚举
 * @author 吴文哲
 * @date 2020-06-05 10:22
 **/
public enum GrassContentPushSceneEnum {

    DAILY_PUSH("daily_push",1,"种草素材早报推送"),
    NOON_PUSH("noon_push",2,"种草素材午间推送"),
    ;


    private String code;

    /**
     * 所在switches的位置  从左往右
     */
    private Integer slot;

    /**
     * 描述
     */
    private String desc;


    GrassContentPushSceneEnum(String code,Integer slot,String desc){
        this.code = code;
        this.slot = slot;
        this.desc = desc;
    }
    /**
     * 根据code获取枚举
     * @param code
     * @return
     */
    public static GrassContentPushSceneEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }

        for(GrassContentPushSceneEnum enums:GrassContentPushSceneEnum.values()){
            if(StringUtils.equals(enums.getCode(),code)){
                return enums;
            }
        }
        return null;
    }

    /**
     * 根据switches值获取code列表值
     * @param switches
     * @return
     */
    public static List<String> getCodeListBySwitches(Integer switches){
        if(NumberUtil.isNullOrLteZero(switches)){
            return Collections.emptyList();
        }
        List<String> results = new ArrayList<>();
        for(GrassContentPushSceneEnum enums:GrassContentPushSceneEnum.values()){
            if((switches & 1 << (enums.getSlot()-1)) > 0L){
                results.add(enums.code);
            }
        }
        return results;
    }

    /**
     * 根据code列表值获取switches值，switches由二进制转换而来
     * @param codes
     * @return
     */
    public static Integer getSwitchesByCodes(List<String> codes){
        if(CollectionUtils.isEmpty(codes)){
            return 0;
        }
        Integer switches = 0;
        for(GrassContentPushSceneEnum enums:GrassContentPushSceneEnum.values()){
            if(codes.contains(enums.getCode())){
                switches = switches | 1<< (enums.getSlot() - 1);
            }
        }
        return switches;
    }


    public String getCode() {
        return code;
    }

    public Integer getSlot() {
        return slot;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 获取查询参数
     * 比方要查 daily_push
     * @param slot 从0开始  从左往右
     * @return
     */
    public static List<Integer> getQueryResult(Integer slot ) {
        List<Integer> resultList = new LinkedList<>();
        int total = 2 << (values().length - 1);
        for (int i = 0; i < total; i++) {
            String binaryStr = decimal2Binary(i, values().length);
            //填写资料的所有可能
            String str = new StringBuffer(binaryStr).reverse().toString();
            if (Objects.equals(str.substring(slot - 1, slot), "1")) {
                resultList.add(Integer.valueOf(binaryStr, 2));
            }
        }
        return resultList;
    }



    /**
     * 将10进制转为指定长度的二进制字符串
     *
     * @param decNum
     * @param digit
     * @return
     */
    public static String decimal2Binary(int decNum, int digit) {
        String binStr = "";
        for (int i = digit - 1; i >= 0; i--) {
            binStr += (decNum >> i) & 1;
        }
        return binStr;
    }

}
