package cn.com.duiba.live.center.api.bean.share;

import cn.com.duiba.live.center.api.enums.ShareTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 直播间分享参数
 * @author lizhi
 * @date 2020/4/12 11:48 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class LiveRoomShareBean extends ShareBean {

    private static final long serialVersionUID = 7184736525915413555L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 分享人的userID
     */
    private Long sharedUserId;

    /**
     * 是否本场直播代理人
     */
    private boolean liveAgent;

    /**
     * 代理人ID
     */
    private Long agentId;

    public LiveRoomShareBean() {
        super(ShareTypeEnum.VISITOR_MP_LIVE_ROOM_INVITATION.getCode());
    }
}
