package cn.com.duiba.live.center.api.enums.live;

import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 直播状态
 * @author lizhi
 * @date 2020/3/30 3:27 PM
 */
public enum LiveStatusEnum {
    LIVE_NOTICE(1, "未开始"),
    LIVE_PROCESSING(2, "直播中"),
    LIVE_INTERRUPT(3, "断网"),
    DATA_STATISTIC_ING(4, "数据统计中"),
    DATA_STATISTIC_END(5, "数据统计完成"),
    DATA_STATISTIC_FAILED(6, "数据统计失败,定时任务自动重试"),
    LIVE_NOT_SHELF(7, "未上架"),
    ;

    /**
     * 结束状态
     */
    public static final List<Integer> END_STATUS = Lists.newArrayList();
    /**
     * 未结束的状态
     */
    public static final List<Integer> NOT_OVER_STATUS = new ArrayList<>();
    /**
     * 正在直播的状态
     */
    public static final List<Integer> LIVING_STATUS = Lists.newArrayList();

    /**
     * 开始的且没有彻底结束（4 :统计中也是未彻底结束）
     */
    public static final List<Integer> START_AND_NOT_END =  new ArrayList<>();

    static {
        NOT_OVER_STATUS.add(1);
        NOT_OVER_STATUS.add(2);
        NOT_OVER_STATUS.add(3);
        END_STATUS.add(4);
        END_STATUS.add(5);
        END_STATUS.add(6);
        LIVING_STATUS.add(2);
        LIVING_STATUS.add(3);

        START_AND_NOT_END.add(2);
        START_AND_NOT_END.add(3);
        START_AND_NOT_END.add(4);
    }

    private Integer code;

    private String desc;

    LiveStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, LiveStatusEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveStatusEnum statusEnum : values()){
            ENUM_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }

    public static LiveStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static boolean isEnd(Integer code) {
        LiveStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum.equals(DATA_STATISTIC_ING) || statusEnum.equals(DATA_STATISTIC_END)
                || statusEnum.equals(DATA_STATISTIC_FAILED);
    }

    /**
     * 直播是否已开始
     *
     * @param code 枚举值
     * @return true-已开始 false-未开始
     */
    public static boolean isStarted(Integer code) {
        return !(LIVE_NOTICE.getCode().equals(code) || LIVE_NOT_SHELF.getCode().equals(code));
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
