package cn.com.duiba.kjy.livecenter.api.constant.mq;

import lombok.Data;

/**
 * @author lizhi
 * @date 2020/3/28 11:31 AM
 */
@Data
public class RocketMqTag {

    private RocketMqTag() {}

    /**
     * 直播企业付款到零钱结果
     */
    public static final String PAY_WX_COMPANY_RESULT = "WX_COM_LIVE";

    /**
     * 批量发送评论
     */
    public static final String BATCH_SEND_SPOKE_MSG = "BATCH_SEND_SPOKE_MSG";

    /**
     * 用户访问的公司记录
     */
    public static final String LIVE_USER_ACCESS_TRACK_COMPANY_MSG = "LIVE_USER_ACCESS_TRACK_COMPANY_MSG";

    /**
     * web socket 直播推送消息
     */
    public static final String WS_LIVE_SEND_MSG = "WS_LIVE_SEND_MSG";

    /**
     * web socket 直播批量推送消息
     * @deprecated 拆分成个人和全部推送
     */
    @Deprecated
    public static final String WS_LIVE_BATCH_SEND_MSG = "WS_LIVE_BATCH_SEND_MSG";

    /**
     * web socket 直播给所有人推送消息
     */
    public static final String WS_LIVE_PUSH_ALL_SEND_MSG = "WS_LIVE_PUSH_ALL_SEND_MSG";

    /**
     * web socket 直播给指定用户推送消息
     */
    public static final String WS_LIVE_PERSONAL_PUSH_SEND_MSG = "WS_LIVE_PERSONAL_PUSH_SEND_MSG";

    /**
     * 红包助力完成
     */
    public static final String LIVE_RED_PACKET_HELP = "LIVE_RED_PACKET_HELP";

    /**
     * 红包已领完
     */
    public static final String LIVE_RED_PACKET_RECEIVE_END = "LIVE_RED_PACKET_RECEIVE_END";

    /**
     * 红包开始收集用户信息
     */
    public static final String LIVE_RED_COLLECT = "LIVE_RED_COLLECT";

    /**
     * 红包开始计算
     */
    public static final String LIVE_RED_COMPUTE = "LIVE_RED_COMPUTE";

    /**
     * 红包停止领取
     */
    public static final String LIVE_RED_STOP_RECEIVE = "LIVE_RED_STOP_RECEIVE";

    /**
     * 红包补马甲结束
     */
    public static final String LIVE_RED_ADD_VEST_AND_END = "LIVE_RED_ADD_VEST_AND_END";

    /**
     * 访客领取红包-发往kjy-web
     * @deprecated 原有流程废弃，见 LIVE_RED_DRAW
     */
    @Deprecated
    public static final String LIVE_RED_DRAW_TO_KJY_WEB = "LIVE_RED_DRAW_TO_KJY_WEB";

    /**
     * 访客领取红包
     */
    public static final String LIVE_RED_DRAW = "LIVE_RED_DRAW";


    /**
     * 抽奖福利，开始计算
     */
    public static final String LIVE_WELFARE_START_COMPUTE = "LIVE_WELFARE_START_COMPUTE";

    /**
     * 多奖项抽奖，开始计算
     */
    public static final String LIVE_MULTI_PRIZE_START_COMPUTE = "LIVE_MULTI_PRIZE_START_COMPUTE";

    /**
     * 预约权益领取推送
     */
    public static final String LIVE_USER_DRAW_WELFARE = "LIVE_USER_DRAW_WELFARE";

    /**
     * 直播间爆款福利定时推送
     */
    public static final String LIVE_BOOM_WELFARE_PUSH = "LIVE_BOOM_WELFARE_PUSH";

    /**
     * 直播预生成 小程序二维码
     */
    public static final String LIVE_PRE_BUILD_MP_QRCODE = "LIVE_PRE_BUILD_MP_QRCODE";

    /**
     * 直播批量预生成小程序二维码，逻辑与LIVE_PRE_BUILD_MP_QRCODE一致，从单条变成多条
     */
    public static final String LIVE_PRE_BUILD_MP_QRCODE_BATCH = "LIVE_PRE_BUILD_MP_QRCODE_BATCH";

    /**
     * 直播批量预生成代理人 小程序二维码
     */
    public static final String LIVE_BATCH_PRE_BUILD_MP_QRCODE = "LIVE_BATCH_PRE_BUILD_MP_QRCODE";



    /**
     * 直播结束，数据统计完成后发送消息通知代理人
     */
    public static final String LIVE_END_SEND_STATISTICS = "LIVE_END_SEND_STATISTICS";

    /**
     * 直播结束，直播用户成为代理人客户
     */
    public static final String LIVE_USER_BEING_SELLER_CUSTOMER = "LIVE_USER_BEING_SELLER_CUSTOMER";

    /**
     * 直播咨询代理人自动回复
     */
    public static final String LIVE_ADVICE_AUTO_REPLY_CUSTOMER = "LIVE_ADVICE_AUTO_REPLY_CUSTOMER";

    /**
     * 直播前抽奖推送
     */
    public static final String LIVE_PRE_LOTTERY_PUSH = "LIVE_PRE_LOTTERY_PUSH";

    /**
     * 直播前抽奖
     */
    public static final String LIVE_PRE_LOTTERY_DRAW = "LIVE_PRE_LOTTERY_DRAW";

    /**
     * 直播中抽奖任务回调
     */
    public static final String LIVE_LOTTERY_DRAW = "LIVE_LOTTERY_DRAW";

    /**
     * 直播中开奖推送
     */
    public static final String LIVE_ING_DRAW_AWARD_PUSH = "LIVE_ING_DRAW_AWARD_PUSH";

    /**
     * 直播黑名单源头任务
     */
    public static final String LIVE_BLACK_SOURCE_TASK = "LIVE_BLACK_SOURCE_TASK";

    /**
     * 福利雨开始收集用户信息
     */
    public static final String LIVE_WELFARE_RAIN_COLLECT = "LIVE_WELFARE_RAIN_COLLECT";

    /**
     * 福利雨开始计算用户
     */
    public static final String LIVE_WELFARE_RAIN_COMPUTE = "LIVE_WELFARE_RAIN_COMPUTE";

    /**
     * 福利雨停止领取
     */
    public static final String LIVE_WELFARE_RAIN_STOP_RECEIVE = "LIVE_WELFARE_RAIN_STOP_RECEIVE";

    /**
     * 福利雨补马甲结束
     */
    public static final String LIVE_WELFARE_RAIN_ADD_VEST_AND_END = "LIVE_WELFARE_RAIN_ADD_VEST_AND_END";

    /**
     * 推啊广告上传
     */
    public static final String TUIA_AD_PUSH = "TUIA_AD_PUSH";


}
