package cn.com.duiba.live.tool.util;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * @author tengtuox
 * @date 2020/9/24
 * @description
 */
public class LocalDateSerializer extends AbstractSerializer {

    public void writeObject(Object obj, AbstractHessianOutput out)
            throws IOException
    {
        if (obj == null)
            out.writeNull();
        else {
            LocalDate localDate = (LocalDate) obj;

            if (out.addRef(obj))
                return;

            Class cl = obj.getClass();

            int ref = out.writeObjectBegin(cl.getName());

            if (ref < -1) {
                out.writeString("value");
                out.writeString(localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                out.writeMapEnd();
            }
            else {
                if (ref == -1) {
                    out.writeInt(1);
                    out.writeString("value");
                    out.writeObjectBegin(cl.getName());
                }

                out.writeString(localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            }
        }
    }
}
