package cn.com.duiba.live.tool.dto.innerlog;

import cn.com.duiba.live.tool.constant.InnerLogTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.UUID;

/**
 * @author hong
 * @date 2021/5/1 6:03 PM
 */
@Data
public class InnerLogDto<T> implements Serializable {

    private static final long serialVersionUID = -6642317195049437697L;

    private Integer group = 18;

    private Integer type;

    private String time;

    private T json;

    private String uuid= UUID.randomUUID().toString().trim().replaceAll("-", "");

    public InnerLogDto(InnerLogTypeEnum typeEnum, T json) {
        this.type = typeEnum.getType();
        this.json = json;
    }
}
