package cn.com.duiba.live.tool.util;

import cn.com.duiba.live.tool.constant.InnerLogTypeEnum;
import cn.com.duiba.live.tool.dto.innerlog.InnerLogDto;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Calendar;

/**
 * Created by hong
 * time 2021/9/17.
 */
public class InnerLogUtil {
    private static final Logger innerLog = LoggerFactory.getLogger("innerLog");

    /**
     * inner日志打印
     * @param typeEnum
     * @param json
     * @param <T>
     */
    public static <T> void innerLog(InnerLogTypeEnum typeEnum, T json) {
        InnerLogDto<T> bean = new InnerLogDto<>(typeEnum, json);
        bean.setTime(DateFormatUtils.format(Calendar.getInstance(), "yyyy-MM-dd HH:mm:ss"));
        innerLog.info(JSON.toJSONString(bean));
    }
}
