package cn.com.duiba.live.tool.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

import java.io.IOException;

/**
 * Created by hong
 * time 2021/9/23.
 * @description: 类型转换成String的序列化方式
 */
public class StringSerializer<T> extends StdScalarSerializer<T> {

    public StringSerializer(Class<T> tClass) {
        super(tClass);
    }

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String text = value == null ? null : String.valueOf(value);
        if (text != null) {
            gen.writeString(text);
        }
    }
}
