package cn.com.duiba.live.tool.constant;

/**
 * @author xujing
 * @date 2021/09/17 10:34 PM
 */
public enum CommonRedisKeyFactory {

    KC0001("点赞hashKey"),
    KC0002("点赞总数key"),
    //按照功能划分 避免冲突 KC01 01 前两位代表功能
    KC0003("停留红包配置"),


    ;

    private static final String SPACE = "DBLIVEALL";
    private static final String SEPARATOR = "_";

    String desc;

    CommonRedisKeyFactory(String desc) {
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    public String lockKey(Object... args) {
        return join(args) + ":lock";
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
