package cn.com.duiba.live.tool.constant;

/**
 * 内部日志类型
 * @author lizhi
 * @date 2020/4/20 6:01 PM
 */
public enum InnerLogTypeEnum {
    SHARE(1,"分享"),
    ONLINE(2,"在线人数"),
    ENTER(3,"进入直播"),
    OUT(4,"退出直播"),
    SPOKE_LIMITER(5,"评论限流"),
    PUBLIC_LIMITER(6,"公共推送限流"),
    LUCK_TASK(7, "幸运任务"),
    DRAW_TASK(8, "中奖任务"),
    INVITE_APPOINTMENT(9, "预约到场日志"),
    WATCH_INTERACTIVE(10,"观看互动日志"),
    GOODS_CLICK(11,"商品（办卡）预约点击日志"),
    RED_COLLECTION(12,"红包领取日志"),
    LUCK_RED_HELP(13,"手气王红包助力日志"),
    GOODS_SALES(14,"商品销量日志"),
    USER_LIKE(15,"用户点赞"),
    ;

    private Integer type;

    private String desc;

    InnerLogTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
