package cn.com.duiba.live.tool.constant;

/**
 * 键值对key枚举
 * 用于 tb_key_to_val_conf表中的key字段的前缀
 * @author 吴文哲
 * @date 2020-08-11 10:07
 **/
public enum KeyToValEnum {
    K001("多奖项抽奖，每轮抽奖人数"),
    K027("访客是否访问过新功能"),
    K033("付费代理新手链路引导"),
    K022("全网链接链接地址"),
    K039("记录代理人每天首页弹层情况"),
    K040("首页弹层配置公司id数组"),
    K045("非微信好友标记"),
    K055("访客保存代理人通讯录行为"),
    K056("访客通讯录保存行为"),
    K063("访问记录额外信息"),
    K064("新功能弹层"),
    K068("活动统计数据"),
    K069("抽奖参与次数"),
    K070("抽奖分享次数"),
    K071("引导销售员关注VIP公众号推送"),
    K072("直播预约办卡"),
    K073("直播间预热轴开关"),
    K074("中信直播间用户办卡问卷"),
    K075("商品批量复制后未编辑标记"),

    ;

    private String desc;

    KeyToValEnum(String desc){
        this.desc = desc;
    }

    private static final String SPACE = "kjy_k2v";
    private static final String SEPARATOR = "_";

    public String getDesc() {
        return desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
}
