/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.tool.exception;

import cn.com.duiba.live.tool.exception.DuibaLiveBizException;
import cn.com.duiba.live.tool.exception.ErrorCode;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class BizChecker {
    public static void checkNotNull(Object o, ErrorCode code) throws DuibaLiveBizException {
        if (o != null) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkIsTrue(boolean expression, ErrorCode code) throws DuibaLiveBizException {
        if (expression) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkNotBlank(String test, ErrorCode code) throws DuibaLiveBizException {
        if (StringUtils.isNotBlank((CharSequence)test)) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkGtZero(Number number, ErrorCode code) throws DuibaLiveBizException {
        if (number != null) {
            if (number instanceof Integer && (Integer)number > 0) {
                return;
            }
            if (number instanceof Long && (Long)number > 0L) {
                return;
            }
            if (number instanceof Float && ((Float)number).floatValue() > 0.0f) {
                return;
            }
            if (number instanceof Double && (Double)number > 0.0) {
                return;
            }
        }
        BizChecker.throwException(code);
    }

    public static void checkNotEmpty(Collection collection, ErrorCode code) throws DuibaLiveBizException {
        if (collection != null && collection.size() > 0) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void checkNotEmpty(Map map, ErrorCode code) throws DuibaLiveBizException {
        if (map != null && map.size() > 0) {
            return;
        }
        BizChecker.throwException(code);
    }

    public static void throwException(ErrorCode code) throws DuibaLiveBizException {
        throw new DuibaLiveBizException(code.getDesc()).withCode(code.getCode());
    }
}

