/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.tool.exception;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.live.tool.exception.DuibaLiveBizException;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class BizExceptionResolverCustom
implements HandlerExceptionResolver,
Ordered {
    private ErrorAttributes errorAttributes;

    public BizExceptionResolverCustom() {
    }

    public BizExceptionResolverCustom(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Throwable t = ex;
        if (t instanceof UndeclaredThrowableException) {
            t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        if (t instanceof BizException) {
            Map<String, Object> body = this.getErrorAttributes(request, false);
            body.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            body.put("error", HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
            if (((BizException)t).getCode() != null) {
                body.put("code", ((BizException)t).getCode());
            }
            body.put("exception", t.getClass().getName());
            body.put("message", t.getMessage());
            String jsonStr = JSON.toJSONString(body);
            try {
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setContentType("application/json;charset=UTF-8");
                IOUtils.write((String)jsonStr, (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return new ModelAndView();
        }
        if (t instanceof DuibaLiveBizException) {
            Map<String, Object> body = this.getErrorAttributes(request, false);
            body.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
            body.put("error", HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
            if (((DuibaLiveBizException)t).getCode() != null) {
                body.put("code", ((DuibaLiveBizException)t).getCode());
            }
            body.put("exception", t.getClass().getName());
            body.put("message", t.getMessage());
            String jsonStr = JSON.toJSONString(body);
            try {
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                IOUtils.write((String)jsonStr, (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return new ModelAndView();
        }
        return null;
    }

    private Map<String, Object> getErrorAttributes(HttpServletRequest request, boolean includeStackTrace) {
        ServletWebRequest webRequest = new ServletWebRequest(request);
        return this.errorAttributes.getErrorAttributes((WebRequest)webRequest, includeStackTrace);
    }
}

