/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.tool.exception;

import cn.com.duiba.boot.netflix.feign.hystrix.HystrixDisabled;
import cn.com.duiba.live.tool.exception.ErrorCode;

@HystrixDisabled
public class DuibaLiveBizException
extends RuntimeException {
    private static final int MAX_DEPTH = 25;
    private static final long serialVersionUID = 3960040295957065211L;
    private String code;

    public DuibaLiveBizException(String message) {
        super(message);
    }

    public DuibaLiveBizException(ErrorCode errorCode) {
        super(errorCode.getDesc());
        this.code = errorCode.getCode();
    }

    public DuibaLiveBizException withCode(String code) {
        this.code = code;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public static DuibaLiveBizException getOrPropagate(Throwable e) {
        Throwable finalE = DuibaLiveBizException.getFinalCause(e);
        if (finalE instanceof DuibaLiveBizException) {
            return (DuibaLiveBizException)finalE;
        }
        throw DuibaLiveBizException.propagate(e);
    }

    private static Throwable getFinalCause(Throwable e) {
        int i = 0;
        Throwable e1 = e;
        while (e1.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e1 = e1.getCause();
        }
        return e1;
    }

    private static RuntimeException propagate(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }
}

