/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.tool.util;

import cn.com.duiba.wolf.utils.DateUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil
extends DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    public static String getInterval(Long longTime) {
        Long long_by_13 = 1000000000000L;
        Long long_by_10 = 1000000000L;
        if (longTime / long_by_13 < 1L && longTime / long_by_10 >= 1L) {
            longTime = Long.parseLong(longTime + "000");
        }
        Timestamp time = new Timestamp(longTime);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long dayConver = 86400000L;
        long hourConver = 3600000L;
        long minConver = 60000L;
        long timeConver = now.getTime() - time.getTime();
        if (timeConver / dayConver < 2L) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            long tempConver = timeConver / dayConver;
            if (tempConver <= 2L && tempConver >= 1L) {
                return "\u6628\u5929" + format.format(time);
            }
            tempConver = timeConver / hourConver;
            if (tempConver >= 1L) {
                return tempConver + "\u5c0f\u65f6\u524d";
            }
            tempConver = timeConver / minConver;
            if (tempConver >= 1L) {
                return tempConver + "\u5206\u949f\u524d";
            }
            return "\u521a\u521a";
        }
        if (timeConver / dayConver < 365L) {
            SimpleDateFormat format = new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm");
            return format.format(time);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        return format.format(time);
    }

    public static String getIntervalV2(long longTime) {
        Date todayFirstTime = DateUtil.getDayDate((Date)new Date());
        Date yesterdayFirstTime = DateUtil.changeByDay((Date)new Date(), (int)-1);
        Date t = new Date(longTime);
        if (t.compareTo(todayFirstTime) >= 1) {
            long interval = System.currentTimeMillis() - longTime;
            long hour = 3600000L;
            long min = 60000L;
            long hourInterval = interval / hour;
            if (hourInterval >= 1L) {
                return hourInterval + "\u5c0f\u65f6\u524d";
            }
            long minInterval = interval / min;
            if (minInterval >= 1L) {
                return minInterval + "\u5206\u949f\u524d";
            }
            return "\u521a\u521a";
        }
        if (t.compareTo(yesterdayFirstTime) >= 1) {
            return "\u6628\u5929" + DateUtil.getMinuteOnlyStr((Date)t);
        }
        SimpleDateFormat format = new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm");
        return format.format(longTime);
    }

    public static String secToTime(String time) {
        String timeStr;
        if (StringUtils.isEmpty((String)time)) {
            return "0\u79d2";
        }
        Integer secTime = Integer.parseInt(time);
        if (secTime <= 0) {
            return "0\u79d2";
        }
        int minute = secTime / 60;
        if (minute < 60) {
            int second = secTime % 60;
            timeStr = (minute == 0 ? "" : minute + "\u5206\u949f") + (second == 0 ? "" : second + "\u79d2");
        } else {
            int hour = minute / 60;
            if (hour > 99) {
                return "99\u65f6";
            }
            int second = secTime - hour * 3600 - (minute %= 60) * 60;
            timeStr = (hour == 0 ? "" : hour + "\u5c0f\u65f6") + (minute == 0 ? "" : minute + "\u5206\u949f") + (second == 0 ? "" : second + "\u79d2");
        }
        return timeStr;
    }

    public static String secToTime1(String time) {
        String timeStr;
        if (StringUtils.isEmpty((String)time)) {
            return "0\u79d2";
        }
        Integer secTime = Integer.parseInt(time);
        if (secTime <= 0) {
            return "0\u79d2";
        }
        int minute = secTime / 60;
        if (minute < 60) {
            int second = secTime % 60;
            timeStr = (minute == 0 ? "" : minute + "\u5206\u949f") + (second == 0 ? "" : second + "\u79d2");
        } else {
            int hour = minute / 60;
            if (hour > 99) {
                return "99\u65f6";
            }
            timeStr = hour + "\u5c0f\u65f6" + ((minute %= 60) == 0 ? "" : minute + "\u5206\u949f");
        }
        return timeStr;
    }

    public static Date changeByMin(Date date, int min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, min);
        return cal.getTime();
    }

    public static boolean isTimeRange() {
        Date end;
        Date begin;
        Date now;
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        try {
            now = df.parse(df.format(new Date()));
            begin = df.parse("9:00");
            end = df.parse("22:00");
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u4e49\u5931\u8d25:[{}]", (Throwable)e);
            return false;
        }
        Calendar nowTime = Calendar.getInstance();
        nowTime.setTime(now);
        Calendar beginTime = Calendar.getInstance();
        beginTime.setTime(begin);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(end);
        return nowTime.before(endTime) && nowTime.after(beginTime);
    }

    public static boolean isCurrentRange(Date time) {
        Date now;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            now = df.parse(df.format(new Date()));
            time = df.parse(df.format(time));
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u4e49\u5931\u8d25:[{}]", (Throwable)e);
            return false;
        }
        Calendar nowTime = Calendar.getInstance();
        nowTime.setTime(now);
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTime(time);
        return nowTime.equals(currentTime);
    }

    public static long getDifferDayNew(Date date) {
        return DateUtil.getDifferDayNew(date, new Date());
    }

    public static long getDifferMinuteNew(Date date) {
        return DateUtil.getDifferMinuteNew(date, new Date());
    }

    public static long getDifferMinuteNew(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) / 60000L;
    }

    public static long getDifferDayNew(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime()) / 86400000L;
    }

    public static Map<String, Date> getDate(Date time) {
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date start = calendar.getTime();
        map.put("startTime", start);
        calendar.add(5, 1);
        calendar.add(13, -1);
        Date end = calendar.getTime();
        map.put("endTime", end);
        return map;
    }

    public static String getDateText(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm");
        return df.format(date);
    }

    public static String getDateText1(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("MM-dd HH:mm");
        return df.format(date);
    }

    public static LocalDate toLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.toLocalDate();
    }

    public static boolean isMonthFirst() {
        String mf = DateUtil.getDayStr((long)DateUtil.getMonthFirstDayTimeInMillis());
        String n = DateUtil.getDayStr((Date)new Date());
        return Objects.equals(mf, n);
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getLiveFormat(Date date) {
        String week = DateUtil.getWeekOfDate(date);
        String time = DateUtil.getMinuteOnlyStr((Date)date);
        return week + " " + time;
    }

    public static Date getDateByDateString(String datetime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime localDateTime = LocalDateTime.parse(datetime, dtf);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long getDifferDayNum(Date d1, Date d2) {
        String toDate;
        long start = d1.getTime();
        long end = d2.getTime();
        long days = (end - start) / 86400000L;
        long runningDays = days + 1L;
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        String fromDate = simpleFormat.format(d1);
        if (!fromDate.equals(toDate = simpleFormat.format(d2))) {
            ++runningDays;
        }
        return runningDays;
    }

    public static long getDifferDayNum2(Date d1, Date d2) {
        long start = d1.getTime();
        long end = d2.getTime();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyyMMdd");
        String fromDate = simpleFormat.format(d1);
        String toDate = simpleFormat.format(d2);
        return Long.valueOf(toDate) - Long.valueOf(fromDate);
    }
}

