/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.tool.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogJsonUtils {
    private static final Logger log = LoggerFactory.getLogger(LogJsonUtils.class);
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("JSON\u5e8f\u5217\u5316\u5931\u8d25, objectClass:{}", (Object)object.getClass().getName(), (Object)e);
            return "";
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new StringSerializer());
        simpleModule.addSerializer((JsonSerializer)new ByteSerializer());
        objectMapper.registerModule((Module)simpleModule);
    }

    private static class ByteSerializer
    extends StdScalarSerializer<byte[]> {
        ByteSerializer() {
            super(byte[].class);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeString((String)null);
                return;
            }
            gen.writeString("byte[]:" + value.length);
        }
    }

    private static class StringSerializer
    extends StdScalarSerializer<String> {
        StringSerializer() {
            super(String.class);
        }

        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeString((String)null);
                return;
            }
            if (value.length() <= 1024) {
                gen.writeString(value);
                return;
            }
            gen.writeString(value.substring(0, 10) + "..." + value.substring(value.length() - 10));
        }
    }
}

