/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.tool.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class StreamUtils {
    public static <T, R> Map<R, T> listToMap(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().collect(Collectors.toMap(mapper, c -> c));
    }

    public static <T, R> Map<R, T> listToLinkedMap(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().collect(Collectors.toMap(mapper, c -> c, StreamUtils.throwingMerger(), LinkedHashMap::new));
    }

    public static <T, R> List<R> mapList(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new ArrayList();
        }
        return source.stream().map(mapper).collect(Collectors.toList());
    }

    public static <T, R> Set<R> mapSet(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashSet();
        }
        return source.stream().map(mapper).collect(Collectors.toSet());
    }

    public static <T> int count(List<T> source, Predicate<? super T> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return 0;
        }
        return (int)source.stream().filter(filter).count();
    }

    public static <R, T, S> Map<R, S> groupingBy(List<T> source, Function<T, R> mapper, Collector<Object, ?, S> counting, Predicate<? super T> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().filter(filter).collect(Collectors.groupingBy(mapper, counting));
    }

    public static <R, T, S> Map<R, S> groupingBy(List<T> source, Function<T, R> mapper, Collector<Object, ?, S> counting) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().collect(Collectors.groupingBy(mapper, counting));
    }

    public static <T, R> Map<R, List<T>> groupingBy(List<T> source, Function<? super T, ? extends R> mapper, Predicate<? super T> filter) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().filter(filter).collect(Collectors.groupingBy(mapper));
    }

    public static <T, R> Map<R, List<T>> groupingBy(List<T> source, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(source)) {
            return new HashMap();
        }
        return source.stream().collect(Collectors.groupingBy(mapper));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <E> void forEach(Integer index, Iterable<? extends E> elements, BiConsumer<Integer, ? super E> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        for (E element : elements) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            action.accept(n, element);
        }
    }
}

