package cn.com.duiba.kjy.api.api.enums.wechat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by sunyan on 2018/1/16.
 */
public enum MessageTypeEnum {

	EVENT("event","wx推送代码审核完成消息"),
	MINI_PROGRAM_PAGE("miniprogrampage","小程序消息，回复抽奖ID，获取领奖链接"),
	TEXT("text","文本消息");

	private final String key;

	// 枚举描述
	private final String desc;

	private static Map<String, String> map = new HashMap<>();

	static {
		for ( MessageTypeEnum messageTypeEnum : EnumSet.allOf(MessageTypeEnum.class) ) {
			map.put(messageTypeEnum.getKey(), messageTypeEnum.getDesc());
		}
	}


	MessageTypeEnum(final String key, final String desc ) {
		this.key = key;
		this.desc = desc;
	}


	public String getKey() {
		return key;
	}


	public String getDesc() {
		return desc;
	}
}
