package cn.com.duiba.kjy.api.api.remoteservice.qrcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeDto;
import cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2020/9/19 11:41 下午
 **/
@AdvancedFeignClient
public interface RemoteMpQrcodeService {
    /**
     * 批量创建小程序码 创建成功后将码加载进redis list中，使用码时直接操作redis即可
     * redisKey {@link cn.com.duiba.kjy.bean.MpQrcodeRedisKeyFactory}
     * value {@link cn.com.duiba.kjy.api.api.dto.qrcode.MpQrcodeSimpleDto}
     *
     * @param count 数量
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     */
    void batchCreateMpQrcode(Integer count, Integer bizType,String appId);

    /**
     * 使用小程序码后需要更新参数
     *
     * @param qrcodeId 主键
     * @param scene 参数
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务对应唯一key 由业务方提供 业务方可以根据该key来获取 长度不超过64
     * @return 执行结果
     */
    int updateMpQrcodeScene(Long qrcodeId, String scene, Integer bizType, String bizKey);

    /**
     * 根据id获取参数
     *
     * @param qrcodeId 主键
     * @return 参数
     */
    String getSceneByQrcodeId(Long qrcodeId);

    /**
     * 根据id获取小程序码
     *
     * @param qrcodeId 主键
     * @return 小程序码
     */
    String getMpQrcodeUrlByQrcodeId(Long qrcodeId);

    /**
     * 根据id获取小程序码
     *
     * @param ids 主键列表
     * @return 小程序码
     */
    List<String> getMpQrcodeUrlByQrcodeIds(List<Long> ids);

    /**
     * 根据业务key来获取小程序码
     *
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @param bizKey 业务对应唯一key 由业务方提供 业务方可以根据该key来获取 长度不超过64
     * @return 小程序码
     */
    String getMpQrcodeUrlByBiz(Integer bizType, String bizKey,Long oaId);

    /**
     * 根据业务类型手动创建单条小程序码
     * 用于降级 不放入redis 当redis中取不到未使用的小程序码时使用
     *
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @return 小程序码
     */
    MpQrcodeSimpleDto createMpQrcode(Integer bizType,String appId);


    /**
     * 根据业务类型手动批量创建小程序码
     * 用于降级 不放入redis 当redis中取不到未使用的小程序码时使用
     *
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.api.api.enums.MpQrcodeBizTypeEnum}
     * @return 小程序码
     */
    List<MpQrcodeSimpleDto> batchCreateMpQrcodeNoRedis(Integer bizType,Integer size,String appId);

    Integer delete(Long id);

    /**
     * 批量更新
     * @param list
     * @return
     */
    Integer batchUpdate(List<MpQrcodeDto> list);
}
