package cn.com.duiba.kjy.api.api.dto.wxmessage;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;
import java.util.Map;

/**
 * Created by dugq on 2020-02-07.
 *  发送目标客户对象
 */
@Data
public class MessageUserDto implements Serializable {
    private static final long serialVersionUID = -5993475953485160587L;

    /**
     * 发送目标客户的open ID
     */
    @NotBlank(message = "openId 不能为空")
    private String openId;

    private Long liveUserId;

    /**
     * 公众号ID
     */
    private Long oaId;

    /**
     * 微信昵称
     */
    private String nickName;

    /**
     * 每个用户不同的额外参数
     */
    private Map<String,Serializable> customMap;
    /**
     * 自定义日志参数
     */
    private Map<String,Serializable> customLogMap;

    /**
     * 用户版本
     */
    private Integer userVersion;

    /**
     * 推送用户类型
     * @see cn.com.duiba.kjy.api.api.enums.PushUserTypeEnum
     * 直播试用账号-通用版：不推送任何客集集全量消息
     */
    private Integer pushUserType;
}
