package cn.com.duiba.kjy.api.api.dto.wxmessage.result;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by zhangshun on 2019/2/1.
 */
@Data
@ToString
public class WechatResultBean implements Serializable {

    private static final long serialVersionUID = 350723056201135289L;
    private Long errcode;
    private String errmsg;
    private String content;

    public Boolean success(){
        return Objects.equals(0L, errcode) || Objects.isNull(errcode);
    }

    public static WechatResultBean requestNoResponse(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-4L);
        wechatResultBean.setErrmsg("请求没有回复");
        return wechatResultBean;
    }

    public static WechatResultBean paramNull(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-2L);
        wechatResultBean.setErrmsg("参数为空");
        return wechatResultBean;
    }

    public static WechatResultBean configNotSend(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-3L);
        wechatResultBean.setErrmsg("配置不发送消息");
        return wechatResultBean;
    }

    public static WechatResultBean paramError(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-5L);
        wechatResultBean.setErrmsg("参数错误");
        return wechatResultBean;
    }

    public static WechatResultBean functionDown(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-6L);
        wechatResultBean.setErrmsg("功能下线");
        return wechatResultBean;
    }

    public static WechatResultBean httpError(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-6L);
        wechatResultBean.setErrmsg("httpclient 发送请求时错误");
        return wechatResultBean;
    }

    public static WechatResultBean requestError(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-7L);
        wechatResultBean.setErrmsg("请求发送异常");
        return wechatResultBean;
    }

    public static WechatResultBean rateLimit(){
        WechatResultBean wechatResultBean = new WechatResultBean();
        wechatResultBean.setErrcode(-8L);
        wechatResultBean.setErrmsg("触发限流，进入队列重新发送");
        return wechatResultBean;
    }
}
