package cn.com.duiba.kjy.api.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 小程序码业务类型枚举
 *
 * @author xuzhigang
 * @date 2020/9/22 12:28 下午
 **/
@Getter
@AllArgsConstructor
public enum MpQrcodeBizTypeEnum {
    LIVE_VISITOR_SHARE(1, "pages/index/index","packages/live/pages/index/index", "kjy/live/mpQrCode", "直播访客分享"),
    LIVE_SHARE(2, "packages/live/pages/index/index","packages/live/pages/index/index", "kjy/live/mpQrCode", "直播分享"),
    LIVE_USER_SING_IN_POINT_SHARE(3, "pages/index/index","pages/index/index", "kjy/live/mpQrCode", "直播用户签到积分分享"),
    COMMUNITY_ACTIVITY_ANSWER(4, "pages/index/index","pages/index/index", "kjy/live/mpQrCode", "社群活动-答题"),
    ;
    /**
     * 业务类型
     */
    private Integer type;

    /**
     * 小程序码跳转页
     */
    private String page;

    /**
     * 小程序码跳转页
     */
    private String newPage;

    /**
     * 小程序码上传至oss地址前缀
     */
    private String ossPrefix;

    /**
     * 描述
     */
    private String desc;

    public static MpQrcodeBizTypeEnum getEnumByType(Integer type) {
        return Arrays.stream(values()).filter(mpQrcodeBizTypeEnum -> Objects.equals(type, mpQrcodeBizTypeEnum.getType()))
                .findFirst()
                .orElse(null);
    }
}
