package cn.com.duiba.kjy.api.api.enums.wechat;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2022/1/17.
 */
@Getter
public enum EventRevokeInfoEnum {
    //1:车牌号,2:地址,3:发票信息,4:蓝牙,5:麦克风,6:昵称和头像,7:摄像头,8:手机号,12:微信运动步数,13:位置信息,14:选中的图片或视频,15:选中的文件,16:邮箱地址
    NUMBER_PLATE(1, "numberPlate", "车牌号"),
    ADDRESS(2, "address", "地址"),
    INVOICE_INFORMATION(3, "invoiceInformation", "发票信息"),
    BLUETOOTH(4, "bluetooth", "蓝牙"),
    MICROPHONE(5, "microphone", "麦克风"),
    NICKNAME_AND_AVATAR(6, "nicknameAndAvatar", "昵称和头像"),
    CAMERA(7, "camera", "摄像头"),
    PHONE_NUMBER(8, "phoneNumber", "手机号"),
    WECHAT_EXERCISE_STEPS(12, "wechatExerciseSteps", "微信运动步数"),
    LOCATION_INFORMATION(13, "locationInformation", "位置信息"),
    SELECTED_IMAGE_OR_VIDEO(14, "selectedImageOrVideo", "选中的图片或视频"),
    SELECTED_FILE(15, "selectedFile", "选中的文件"),
    EMAIL_ADDRESS(16, "emailAddress", "邮箱地址");

    private final Integer code;

    private final String  type;

    private final String  desc;

    EventRevokeInfoEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static EventRevokeInfoEnum getByCode(Integer code) {
        return Stream.of(EventRevokeInfoEnum.values())
                     .filter(e -> e.getCode()
                                   .equals(code))
                     .findFirst()
                     .orElse(NICKNAME_AND_AVATAR);
    }

    public static EventRevokeInfoEnum getByType(String type) {
        return Stream.of(EventRevokeInfoEnum.values())
                     .filter(e -> e.getType()
                                   .equals(type))
                     .findFirst()
                     .orElse(NICKNAME_AND_AVATAR);
    }
}