package cn.com.duiba.kjy.api.api.remoteservice.util;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 微信调用服务
 * @author 吴文哲
 * @date 2020-09-18 14:03
 **/
@AdvancedFeignClient
public interface RemoteWechatQrCodeService {

    /**
     * 微信通过二维码图片识别二维码内容
     * @param accessToken
     * @param imgUrl 二维码图片
     * @return 二维码中的内容
     */
    String scanQrCodeUrl(String accessToken, String imgUrl);

    /**
     * 微信通过二维码图片识别二维码内容
     *
     * @param imgUrl 二维码图片
     * @return 二维码中的内容
     */
    String scanQrCodeContent(String imgUrl);
}
