package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.WxAuthorizerMemberDto;

import java.util.List;

/**
 * 微信小程序成员管理api
 *
 * @Author xujing
 * @Date 2021/1/26 11:29 上午
 */
@AdvancedFeignClient
public interface RemoteWechatMiniMemberManageService {

    /**
     * 获取所有小程序体验成员
     *
     * @param appId
     * @return
     */
    List<WxAuthorizerMemberDto> listByAppId(String appId);

    /**
     * 添加体验者
     *
     * @param appId
     * @param wechatId
     * @param remark
     * @return
     */
    Boolean addMember(String appId, String wechatId, String remark) throws BizException;

    /**
     * 删除体验者
     *
     * @return
     */
    Boolean delMember(Long id) throws BizException;

    /**
     * 更新体验者的备注
     *
     * @param id
     * @param remark
     * @return
     */
    Boolean updateRemark(Long id, String remark) throws BizException;

    /**
     * 同步微信端的所有体验者
     */
    Boolean refreshMembers(String appId) throws BizException;

    /**
     * 查看体验者详情
     */
    WxAuthorizerMemberDto findById(Long id);

}
