package cn.com.duiba.kjy.api.api.remoteservice.wechat.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.coupon.WxPayUserCouponRecordDto;
import cn.com.duiba.kjy.api.api.param.wechat.coupon.CouponSearchParam;
import cn.com.duiba.kjy.api.api.param.wechat.coupon.CouponSendParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/7/28 2:50 下午
 */
@AdvancedFeignClient
public interface RemoteWxPayUserCouponRecordService {

    /**
     * 发送优惠券
     *
     * @param param 发送优惠券参数
     */
    void sendCoupon(CouponSendParam param);

    /**
     * 将优惠券状态更新为已使用
     * 并回填支付单号
     */
    Integer updateUsedByWxCouponId(String wxCouponId, String payOrderNo);

    /**
     * 更新为退款中
     */
    Integer updateRefundByOrderNo(String payOrderNo);

    /**
     * 更新为退款成功或者退款失败
     */
    Integer updateRefundSuccessByOrderNo(String payOrderNo,Boolean success);

    /**
     * 根据条件查询
     *
     * @param searchParam
     * @return
     */
    List<WxPayUserCouponRecordDto> listByParam(CouponSearchParam searchParam);

    /**
     * 根据条件查询数量
     *
     * @param searchParam
     * @return
     */
    Integer countByParam(CouponSearchParam searchParam);
}
