package cn.com.duiba.kjy.api.api.bean.wxpay.result;

import cn.com.duiba.kjy.api.api.annotation.FieldMapKey;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信企业付款到零钱返回结果
 * @author lizhi
 * @date 2020/4/1 3:25 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxPayCompanyResult extends BaseWxResult {

    private static final long serialVersionUID = -4862440814402697237L;

    /**
     * 商户订单号
     * String(32)
     */
    @FieldMapKey("partner_trade_no")
    private String partnerTradeNo;

    /**
     * 微信付款单号
     * String(64)
     */
    @FieldMapKey("payment_no")
    private String paymentNo;

    /**
     * 企业付款成功时间
     * String(32)
     * 2015-05-19 15:26:59
     */
    @FieldMapKey("payment_time")
    private String paymentTime;
}
